using System;
using System.Collections.Generic;
using System.Text;
using System.Net.Mail;
using System.Net;
using System.Xml;
using Gemini.Core.BL.Interface;

namespace PI.ZB.N1200.ELearning.BL
{
    public partial class ZSBELearning : Gemini.Core.BL.Base.BusinessLogicPlugIn
    {
        public ZSBELearning(Gemini.Core.BL.Interface.IEnvironment Environment)
            : base(Environment){}

        public override long ClientID
        {
            get { return Dictionary.Clients.PlugIn; }
        }

        public override string Name
        {
            get { return  Dictionary.PLUGIN_NAME; }
        }

        public PI.GM.N610.ELearning.BL.ELearning BLELearning
        {
            get { return RBL.ELearning; }
        }

        #region Narzdzia, CheckEmail
        /// <summary>
        /// Dla usera bedacego stidentem lub instruktorem podaje jego haso,
        /// jezeli kto nie jest studentem lub instruktorem metoda zwrci NULL.
        /// </summary>
        /// <param name="Email"></param>
        /// <returns></returns>
        public string GetUserPassword(string Email)
        {
            PI.FM.N001.Account.BL.BO.User _user = RBL.Account.User.View.RestoreByEmail(Email);
            if (_user != null)
            {
                return _user.Password;
            }
            return null;
        }

        /// <summary>
        /// Metoda sprawdza czy podany login naley do studenta/instruktora
        /// i jeeli tak wysya Email z przypomnieniem hasa i zwraca True,
        /// w przeciwnym wypadku zwraca False
        /// </summary>
        /// <param name="Email"></param>
        /// <returns></returns>
        public bool SendRemindPasswordEmail(string Email)
        {
            Gemini.Core.BL.Base.MethodResult _result = RBL.Account.User.EmailPassword(RBL.Account.User.View.RestoreByEmail(Email));
            return _result != null ? _result.Success : false;
        }
        #endregion

                /// <summary>
        /// Czy jest uytkownik o danym ID studenta lub instruktora istnieje i zgadza sie dla niego Login i Haslo
        /// </summary>
        /// <param name="Id"></param>
        /// <param name="Login"></param>
        /// <param name="Password"></param>
        /// <returns></returns>
        public bool IsUserSessionActive(string Id, string Login, string Sessionuid)
        {
            PI.FM.N001.Account.BL.BO.User _user = RBL.Account.User.RestoreByID(long.Parse(Id));
            ISession _session = null;
            if (Environment.SessionManager != null)
            {
                _session = Environment.SessionManager.Get(Sessionuid);
            }
            return (_user != null && _user.Login == Login && _session != null);
        }

        /// <summary>
        /// czy istnieje uytkownik o zadanym ID i ma aktywn sesj
        /// </summary>
        /// <param name="Id"></param>
        /// <param name="SessionId"></param>
        /// <returns></returns>
        public bool IsUserSessionActive(string Id, string SessionUID)
        {
            PI.FM.N001.Account.BL.BO.User _user = RBL.Account.User.RestoreByID(long.Parse(Id));
            ISession _session = null;
            if (Environment.SessionManager != null)
            {
                _session = Environment.SessionManager.Get(SessionUID);
            }
            return (_user != null && _session != null && _session.UserID == _user.ID);
        }

        /// <summary>
        /// Aktualizuje zarobki studenta dla uytkownika UserID pochodzce z gry eduFarma
        /// </summary>
        /// <param name="UserID"></param>
        /// <param name="Salary"></param>
        /// <returns></returns>
        public bool UpdateStudentMoney(long UserID, int Money)
        {
            PI.FM.N001.Account.BL.BO.User _user = RBL.Account.User.RestoreByID(UserID);
            if (_user != null)
            {
                BL.BO.Student _student = Student.RestoreByUser(_user);
                if (_student != null)
                {
                    _student.GameCash = Money;
                    return Student.Save(_student).Success;
                }
            }
            return false;
        }
    }
}